from bpy.types import Operator
from ....libs.functions.animation import anim_attrs
from ....libs.functions.get_common_vars import get_common_vars
from bpy.props import StringProperty


class FLUIDLAB_OT_forces_anim_props(Operator):
    bl_idname = "fluidlab.forces_anim_props"
    bl_label = "Stop Force Here"
    bl_description = "Stop Force Here"
    bl_options = {'REGISTER', 'UNDO'}

    prop_name: StringProperty(default="")


    def anim_props(self, field, anim_props) -> None:

        _start = getattr(anim_props, self.prop_name + "_start")
        _from = getattr(anim_props, self.prop_name + "_from")
        _increase = getattr(anim_props, self.prop_name + "_increase")
        _duration = getattr(anim_props, self.prop_name + "_duration")
        _decrease = getattr(anim_props, self.prop_name + "_decrease")
        _to = getattr(anim_props, self.prop_name + "_to")
        _increase_decrease = getattr(anim_props, self.prop_name + "_inc_dec")

        data =  {
                    'object':  field, 
                    'dpath':   self.prop_name, 
                    'frame':   _start,
                    'value':   _from
        }
        anim_attrs(data)

        
        if _increase_decrease:
            data =  {
                        'object':  field, 
                        'dpath':   self.prop_name, 
                        'frame':   _start + _increase,
                        'value':   _to
            }
            anim_attrs(data)
        
        data =  {
                    'object':  field, 
                    'dpath':   self.prop_name, 
                    'frame':   _start + _duration,
                    'value':   _to
        }
        anim_attrs(data)

        if _increase_decrease:
            data =  {
                        'object':  field, 
                        'dpath':   self.prop_name, 
                        'frame':   _start + _duration + _decrease,
                        'value':   _from
            }
            anim_attrs(data)
        
        setattr(anim_props, self.prop_name + "_animed", True)


    def get_field(self, f_forces, force_ob):
        
        field = None

        # Para Emitters
        if f_forces.ff_sections == 'EMITTER':

            psys = force_ob.particle_systems.active
            if psys:
                field = psys.settings.force_field_1
            else:
                print(f"object {force_ob.name} without active particles, skip!")
            
        else: # <- Para Global y Colliders

            if not hasattr(force_ob, "field"):
                print(f"object {force_ob.name} not have field, skip!")
                return
            
            if force_ob.field is None:
                print(f"object {force_ob.name} not have field, skip!")
                return
            
            if force_ob.field.type == 'NONE':
                print(f"object {force_ob.name} with field NONE, skip!")
                return

            field = force_ob.field
        
        return field


    def execute(self, context): 

        wm = context.window_manager
        fluidlab = get_common_vars(context, get_fluidlab=True)
        f_forces = fluidlab.fluid_forces

        # anim_props = force_ob.fluid_settings_anim # <- para borrar

        if "anim_force_ob" in wm:
            force_ob = wm["anim_force_ob"]
            anim_props = force_ob.fluidlab.force_anim

            is_animed = getattr(anim_props, self.prop_name + "_animed")
            if not is_animed: # entonces lo animamos:
                
                field = self.get_field(f_forces, force_ob)
                self.anim_props(field,  anim_props)

            else: # entonces lo borramos:
                
                container = None

                # Para Emitters
                if f_forces.ff_sections == 'EMITTER':

                    psys = force_ob.particle_systems.active
                    if psys:
                    
                        container = psys.settings
                        prefix_dpath = "force_field_1."
                    
                    else:
                    
                        print(f"object {force_ob.name} without active particles, skip!")
                        return {'CANCELLED'}
                    
                else: # <- Para Global y Colliders
                    container = force_ob
                    prefix_dpath = "field."
                
                # comprobamos que tengan datos de animacion:
                if container.animation_data:
                
                    action = container.animation_data.action
                    if action:
                        
                        if container.animation_data.action.fcurves:
                            
                            fcurve = action.fcurves.find(data_path=prefix_dpath + self.prop_name, index=0)
                            if fcurve:
                            
                                action.fcurves.remove(fcurve)
                        
                                # Para el toggle de Add/Remove:
                                setattr(anim_props, self.prop_name + "_animed", False)

        return {'FINISHED'}